# -*- coding: utf-8 -*-

import names
import os
from toplevelwindow import *

def main():
    ##### INIT START #####
    #define the name of the windows application
    winAutName = "Addressbook"
    
    #start the windows application
    ctx_win = startApplication(winAutName)
    
    #retrieve toplevel object 
    winToplevel = ToplevelWindow.byObject(waitForObject(names.address_Book_Unnamed_Window))
    # minimize the windows application
    winToplevel.minimize()
    
    #path to Squish for web package
    squishPackageWeb = "C:\\Users\\Kati\\Squish\ for\ Web 7.1.1"
    #define the website to visit after the browser started
    website = "https://www.qt.io/product/quality-assurance"
    #squishserver port for Squish for web
    squishServerWeb = 4444
    #host name of the squishserver, run locally
    host = "localhost"    
    #override current environment variable to Squish for web package
    os.environ["SQUISH_PREFIX"] = squishPackageWeb
    #set the right wrapper for the application
    testSettings.setWrappersForApplication("__squish__webhook", ["Web"])
    #start webhook application using this squishserver
    ctx_web = startApplication("__squish__webhook",host, squishServerWeb)
    #start the browser
    startBrowser(website)
    ##### INIT END #####

    #set application context to the windows application
    setApplicationContext(ctx_win);
    #revert the "minimize" command
    winToplevel.restore()

    #interact with the windows application
    createNewAddressbook()
    addEntry("Peter", "Burton", "pb@myemail.de", "001568765432756")
    winToplevel.minimize()

    #interact with the browser
    setApplicationContext(ctx_web);
    startSquishTrial()

def createNewAddressbook():
    mouseClick(waitForObjectItem(names.address_Book_Unnamed_Menubar, "File"))
    mouseClick(waitForObjectItem(names.file_MenuItem, "New"))

def addEntry(forname, surname, email, phone):
    mouseClick(waitForObject(names.add_ToolbarItem))
    type(waitForObject(names.address_Book_Add_Forename_Edit), forname)
    type(waitForObject(names.address_Book_Add_Surname_Edit), "<Tab>")
    type(waitForObject(names.address_Book_Add_Surname_Edit), surname)
    type(waitForObject(names.address_Book_Add_Email_Edit), "<Tab>")
    type(waitForObject(names.address_Book_Add_Email_Edit), email)
    type(waitForObject(names.address_Book_Add_Phone_Edit), "<Tab>")
    type(waitForObject(names.address_Book_Add_Phone_Edit), phone)
    clickButton(waitForObject(names.address_Book_Add_OK_Button))

def startSquishTrial():
    clickLink(waitForObject(names.quality_Assurance_Software_Tools_Cross_Platform_Testing_Qt_Squish_A))
    clickLink(waitForObject(names.squish_GUI_Test_Automation_Quality_Assurance_Start_your_free_trial_A))
